--[[
    UnloadTypeChangeEvent

	Sync event for changing the unload type of a potato seeder.

	@author: 	BayernGamers
	@date: 		21.05.2025
	@version:	1.0

	History:	v1.0 @21.05.2025 - initial implementation in FS25
				-------------------------------------------------------------------------------------------

	License:    Terms:
                    Usage:
                        Feel free to use this work as-is as long as you adhere to the following terms:
                    Attribution:
                        You must give appropriate credit to the original author when using this work.
                    No Derivatives:
                        You may not alter, transform, or build upon this work in any way.
                    Usage:
                        The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                    Additional Clause:
                        This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "UnloadTypeChangeEvent.lua")

UnloadTypeChangeEvent = {}
UnloadTypeChangeEvent_mt = Class(UnloadTypeChangeEvent, Event)

InitEventClass(UnloadTypeChangeEvent, "UnloadTypeChangeEvent")

function UnloadTypeChangeEvent.emptyNew()
    local self = Event.new(UnloadTypeChangeEvent_mt)
    return self
end

function UnloadTypeChangeEvent.new(vehicle, unloadFillTypeIndex)
    local self = UnloadTypeChangeEvent.emptyNew()
    self.vehicle = vehicle
    self.unloadFillTypeIndex = unloadFillTypeIndex

    return self
end

function UnloadTypeChangeEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.unloadFillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

    self:run(connection)
end

function UnloadTypeChangeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteUIntN(streamId, self.unloadFillTypeIndex, FillTypeManager.SEND_NUM_BITS)
end

function UnloadTypeChangeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
    
    if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
        self.vehicle.spec_unloadPotatoSeeder.unloadFillTypeIndex = self.unloadFillTypeIndex
    end
end

function UnloadTypeChangeEvent.sendEvent(vehicle, unloadFillTypeIndex, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(UnloadTypeChangeEvent.new(vehicle, unloadFillTypeIndex), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(UnloadTypeChangeEvent.new(vehicle, unloadFillTypeIndex))
        end
    end
end