--============================================================--
--  REA Main Loader v1.0.7 – by Papa_Matze
--============================================================--

REA = {}
REA.version = "1.0.7"

----------------------------------------------------------------
-- REA Feature Flags
----------------------------------------------------------------
REA.FEATURES = {
    TemperaturePhysics   = true,
    TirePressureSystem   = true,
    SlipSoilDamage       = true,
    TireSound            = true,
    EngineTempInfluence  = true,
    FlipRisk             = true
}

----------------------------------------------------------------
-- Debug
----------------------------------------------------------------
function REA:log(msg)
    print("[REA] " .. tostring(msg))
end

----------------------------------------------------------------
-- Modules laden
----------------------------------------------------------------
local function loadFile(name)
    local path = g_modsDirectory .. "/FS25_REA_by_Papa_Matze_v1_0_4_beta/" .. name
    if fileExists(path) then
        source(path)
        REA:log("Loaded " .. name)
    else
        REA:log("WARNING: Missing file → " .. name)
    end
end

loadFile("REAimplements.lua")        -- Physics & handling
loadFile("REAwheels_fixed.lua")      -- Wheel effects
loadFile("READynamicDirt.lua")       -- Dirt & coloring
loadFile("REAcog.lua")               -- COG / center of gravity

----------------------------------------------------------------
-- Init
----------------------------------------------------------------
function REA.init()
    REA:log("REA v" .. REA.version .. " initialized")
end

Mission00.loadMission00Finished = Utils.appendedFunction(
    Mission00.loadMission00Finished,
    REA.init
)

--============================================================--
-- ENDE
--============================================================--
