----------------------------------------------------------------
-- REA_slipSoundAddon.lua
-- Additives Akustik-Addon für REAPlus (LS25)
--
-- Ergänzt:
--  - Schlupf früher & länger (=> mehr LS25-Reifensound)
--  - Motorlast akustisch stärker (mehr Dröhnen / Arbeitsgeräusch)
--
-- WICHTIG:
--  - Ersetzt KEINE bestehende Datei
--  - Löscht NICHTS
--  - Originale REA_terrainDepth.lua bleibt unverändert
----------------------------------------------------------------

do
    -- mögliche Hauptklassen-Namen (je nach REAPlus-Version)
    local TD =
        REA_terrainDepth
        or REA_TerrainDepth
        or REAterrainDepth
        or REA_TerrainDepthSystem

    if TD ~= nil and TD.update ~= nil then
        local oldUpdate = TD.update

        TD.update = function(self, dt)
            -- Originale REAPlus-Logik läuft vollständig
            oldUpdate(self, dt)

            if g_currentMission == nil then return end
            if g_currentMission.vehicles == nil then return end

            for i = 1, #g_currentMission.vehicles do
                local vehicle = g_currentMission.vehicles[i]
                if vehicle ~= nil and vehicle.spec_motorized ~= nil then

                    ------------------------------------------------------------
                    -- OPTION 1: SCHLUPF FRÜHER & LÄNGER
                    -- -> LS25 spielt automatisch mehr Slip-/Reifensounds
                    ------------------------------------------------------------
                    local slip = vehicle.reaSlipIndex or 0

                    -- Bodenfeuchte (falls von REA gesetzt)
                    local soil = vehicle.reaSoilMoisture
                    if soil ~= nil and soil > 0.35 then
                        slip = slip + 0.12 * soil
                    end

                    -- Achslast / Anhängerlast (falls von REA gesetzt)
                    local axle = vehicle.reaAxleLoadFactor
                    if axle ~= nil and axle > 1.0 then
                        slip = slip + (axle - 1.0) * 0.15
                    end

                    -- Festfahren: wenig Speed + vorhandener Schlupf
                    local speed = 0
                    if vehicle.getLastSpeed ~= nil then
                        speed = vehicle:getLastSpeed() or 0
                    end
                    if speed < 2 and slip > 0.2 then
                        slip = slip + 0.20
                    end

                    -- Schlupf langsamer abbauen (Sound bleibt hörbar)
                    local prevSlip = vehicle.reaSlipIndex or 0
                    vehicle.reaSlipIndex = math.max(slip, prevSlip * 0.92)

                    ------------------------------------------------------------
                    -- OPTION 2: MOTORLAST AKUSTISCH BETONEN
                    -- -> mehr Dröhnen / Arbeitsgeräusch unter Zug
                    ------------------------------------------------------------
                    local spec = vehicle.spec_motorized
                    local motor = spec.motor
                    if motor ~= nil then
                        local load = spec.smoothedLoadPercentage or 0

                        if load > 0.60 then
                            motor.soundLoadFactor =
                                math.min(1.25, 1.0 + load * 0.35)
                            motor.rpmSmoothing = 0.88
                        else
                            motor.soundLoadFactor = 1.0
                        end
                    end
                end
            end
        end
    end
end
