-- REA_AddSpecialization.lua
-- FS25-sichere REA-Spezialisierungsregistrierung
-- registriert dirtyTireTracks + REAsoilTracks für kompatible Fahrzeugtypen

REA_AddSpec = {}
REA_AddSpec.modDir = g_currentModDirectory or ""

local function safePrint(msg)
    print(("REA_AddSpec: %s"):format(tostring(msg)))
end

---------------------------------------------------------------------
-- Spezialisierungen registrieren
---------------------------------------------------------------------
function REA_AddSpec.registerSpecs()
    if g_specializationManager == nil or g_vehicleTypeManager == nil then
        safePrint("Spezialisierungssystem noch nicht bereit, Abbruch.")
        return
    end

    ------------------------------------------------------------
    -- 1) dirtyTireTracks
    ------------------------------------------------------------
    local dirtName = "dirtyTireTracks"
    if g_specializationManager:getSpecializationByName(dirtName) == nil then
        local dirtFile = REA_AddSpec.modDir .. "dirtyTireTracks.lua"
        safePrint(("Registriere Spezialisierung '%s' aus %s"):format(dirtName, dirtFile))
        g_specializationManager:addSpecialization(
            dirtName, dirtName, dirtFile, nil
        )
    else
        safePrint("dirtyTireTracks bereits vorhanden – überspringe Registrierung.")
    end

    ------------------------------------------------------------
    -- 2) REAsoilTracks
    ------------------------------------------------------------
    local soilName = "REAsoilTracks"
    if g_specializationManager:getSpecializationByName(soilName) == nil then
        local soilFile = REA_AddSpec.modDir .. "REAsoilTracks.lua"
        safePrint(("Registriere Spezialisierung '%s' aus %s"):format(soilName, soilFile))
        g_specializationManager:addSpecialization(
            soilName, soilName, soilFile, nil
        )
    else
        safePrint("REAsoilTracks bereits vorhanden – überspringe Registrierung.")
    end

    ----------------------------------------------------------------
    -- Jetzt zu allen Fahrzeugtypen hinzufügen
    ----------------------------------------------------------------
    local vehicleTypes = g_vehicleTypeManager.vehicleTypes
    if vehicleTypes == nil then
        safePrint("FEHLER: vehicleTypes ist NIL – Spezialiserungen werden später erneut versucht.")
        return
    end

    for typeName, typeEntry in pairs(vehicleTypes) do
        if typeEntry ~= nil and typeEntry.specializationsByName ~= nil then

            local hasWheels    = typeEntry.specializationsByName["wheels"] ~= nil
            local hasDrivable  = typeEntry.specializationsByName["drivable"] ~= nil

            if hasWheels or hasDrivable then

                ------------------------------------------------
                -- dirtyTireTracks anhängen
                ------------------------------------------------
                if typeEntry.specializationsByName["dirtyTireTracks"] == nil then
                    safePrint(("Füge dirtyTireTracks zu Fahrzeugtyp '%s' hinzu"):format(typeName))
                    g_vehicleTypeManager:addSpecialization(typeName, "dirtyTireTracks")
                end

                ------------------------------------------------
                -- REAsoilTracks anhängen
                ------------------------------------------------
                if typeEntry.specializationsByName["REAsoilTracks"] == nil then
                    safePrint(("Füge REAsoilTracks zu Fahrzeugtyp '%s' hinzu"):format(typeName))
                    g_vehicleTypeManager:addSpecialization(typeName, "REAsoilTracks")
                end
            end
        end
    end
end

---------------------------------------------------------------------
-- FS25: richtige Ladeposition – NACH VehicleType-Aufbau
---------------------------------------------------------------------
REA_AddSpec_Event = {}

function REA_AddSpec_Event:onGameLoaded()
    safePrint("Game vollständig geladen → REA Spezialiserungen werden jetzt registriert")
    REA_AddSpec.registerSpecs()
end

function REA_AddSpec_Event:update(dt) end
function REA_AddSpec_Event:draw() end

addModEventListener(REA_AddSpec_Event)
