FSDensityMapUtilExtension = {
    growingFruitFilters = {},
    densityMapModifiersDestroyFruit = {}
}

function FSDensityMapUtilExtension.updateMulcherArea(startWorldX, superFunc, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    if g_modIsLoaded["FS25_precisionFarming"] then
        local nitrogenMap = FS25_precisionFarming.g_precisionFarming.nitrogenMap
		FSDensityMapUtilExtension.updateDestroyCommonArea(nitrogenMap, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
        local changeArea, changeTotalArea = superFunc(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
		FSDensityMapUtilExtension.postUpdateDestroyCommonArea(nitrogenMap, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
		return changeArea, changeTotalArea
    else
        FSDensityMapUtilExtension.vanillaUpdateMulcherArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
        local changeArea, changeTotalArea = superFunc(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
        return changeArea, changeTotalArea
    end
end

FSDensityMapUtil.updateMulcherArea = Utils.overwrittenFunction(FSDensityMapUtil.updateMulcherArea, FSDensityMapUtilExtension.updateMulcherArea)

function FSDensityMapUtilExtension.vanillaUpdateMulcherArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    if FSDensityMapUtilExtension.sprayLevelModifier == nil then
        FSDensityMapUtilExtension.multiModifier = DensityMapMultiModifier.new()
        local multiModifier = FSDensityMapUtilExtension.multiModifier
        local terrainRootNode = g_currentMission.terrainRootNode
        local fieldGroundSystem = g_currentMission.fieldGroundSystem
        local groundTypeMapId, groundTypeFirstChannel, groundTypeNumChannels = fieldGroundSystem:getDensityMapData(FieldDensityMap.GROUND_TYPE)
        local sprayLevelMapId, sprayLevelFirstChannel, sprayLevelNumChannels = fieldGroundSystem:getDensityMapData(FieldDensityMap.SPRAY_LEVEL)
        local maxValue = fieldGroundSystem:getMaxValue(FieldDensityMap.SPRAY_LEVEL)
        FSDensityMapUtilExtension.sprayLevelModifier = DensityMapModifier.new(sprayLevelMapId, sprayLevelFirstChannel, sprayLevelNumChannels, terrainRootNode)

        FSDensityMapUtilExtension.maskFilter = DensityMapFilter.new(sprayLevelMapId, sprayLevelFirstChannel, sprayLevelNumChannels)
        FSDensityMapUtilExtension.maskFilter:setValueCompareParams(DensityValueCompareType.BETWEEN, 0, maxValue - 1)

        FSDensityMapUtilExtension.fieldFilter = DensityMapFilter.new(groundTypeMapId, groundTypeFirstChannel, groundTypeNumChannels)
        FSDensityMapUtilExtension.fieldFilter:setValueCompareParams(DensityValueCompareType.GREATER, 0)

        for _, desc in pairs(g_fruitTypeManager:getFruitTypes()) do
            if desc.terrainDataPlaneId ~= nil then
                local growingFruitFilter = DensityMapFilter.new(desc.terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels)
                growingFruitFilter:setValueCompareParams(DensityValueCompareType.BETWEEN, 2, desc.numGrowthStates)
                multiModifier:addExecuteAdd(1, FSDensityMapUtilExtension.sprayLevelModifier, growingFruitFilter, FSDensityMapUtilExtension.maskFilter, FSDensityMapUtilExtension.fieldFilter)
                table.insert(FSDensityMapUtilExtension.growingFruitFilters, growingFruitFilter)
            end
        end
    end

    local multiModifier = FSDensityMapUtilExtension.multiModifier

    multiModifier:updateParallelogramWorldCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, DensityCoordType.POINT_POINT_POINT)
    multiModifier:resetStats()
    multiModifier:execute()
end

local function worldCoordsToLocalCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, size, terrainSize)
	return size * (startWorldX + terrainSize * 0.5) / terrainSize, size * (startWorldZ + terrainSize * 0.5) / terrainSize, size * (widthWorldX + terrainSize * 0.5) / terrainSize, size * (widthWorldZ + terrainSize * 0.5) / terrainSize, size * (heightWorldX + terrainSize * 0.5) / terrainSize, size * (heightWorldZ + terrainSize * 0.5) / terrainSize
end

function FSDensityMapUtilExtension.updateDestroyCommonArea(nitrogenMap, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local soilMap = nitrogenMap.soilMap
	if soilMap ~= nil and soilMap.bitVectorMap ~= nil then
		local modifier = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifier
		local nFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.nFilter
		local fruitFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitFilter
		local mulchFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.mulchFilter
		local modifierLock = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifierLock
		local lockFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.lockFilter
		local fruitIndices = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitIndices
		if modifier == nil or (nFilter == nil or (fruitFilter == nil or (modifierLock == nil or (lockFilter == nil or fruitIndices == nil)))) then
            FSDensityMapUtilExtension.maxValue = nitrogenMap.maxValue
            FSDensityMapUtilExtension.mapSize = nitrogenMap.sizeX
            FSDensityMapUtilExtension.catchCropsStateChange = nitrogenMap.catchCropsStateChange

            FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifier = DensityMapModifier.new(nitrogenMap.bitVectorMap, nitrogenMap.firstChannel, nitrogenMap.numChannels, g_terrainNode)
			modifier = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifier
			modifier:setPolygonRoundingMode(DensityRoundingMode.INCLUSIVE)

            FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.nFilter = DensityMapFilter.new(nitrogenMap.bitVectorMap, nitrogenMap.firstChannel, nitrogenMap.numChannels)
            FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.nFilter:setValueCompareParams(DensityValueCompareType.BETWEEN, 0, FSDensityMapUtilExtension.maxValue - 1)

			FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitFilter = DensityMapFilter.new(modifier)
			fruitFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitFilter

            FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.mulchFilter = DensityMapFilter.new(modifier)
			mulchFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.mulchFilter

			FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifierLock = DensityMapModifier.new(nitrogenMap.bitVectorMapNFruitDestroyMask, 0, 2, g_terrainNode)
			modifierLock = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifierLock
			modifierLock:setPolygonRoundingMode(DensityRoundingMode.INCLUSIVE)

			FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.lockFilter = DensityMapFilter.new(nitrogenMap.bitVectorMapNFruitDestroyMask, 0, 2)
			FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.lockFilter:setValueCompareParams(DensityValueCompareType.EQUAL, 1)

			FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitIndices = {}
			fruitIndices = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitIndices
			for i = 1, 15 do
				fruitIndices[i] = {
					terrainDataPlaneId = 0,
					index = 0,
					active = false
				}
			end
		end
		startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ = worldCoordsToLocalCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, FSDensityMapUtilExtension.mapSize, g_currentMission.terrainSize)
		modifierLock:setParallelogramDensityMapCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, DensityCoordType.POINT_POINT_POINT)

		for i = 1, 15 do
			fruitIndices[i].active = false
		end

		modifierLock:executeSet(0)
		for index, desc in pairs(g_fruitTypeManager:getFruitTypes()) do
			if desc.weed == nil and desc.terrainDataPlaneId ~= nil then
				fruitFilter:resetDensityMapAndChannels(desc.terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels)
                fruitFilter:setValueCompareParams(DensityValueCompareType.BETWEEN, 2, desc.numGrowthStates)
				mulchFilter:resetDensityMapAndChannels(desc.terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels)
                mulchFilter:setValueCompareParams(DensityValueCompareType.NOTEQUAL, desc.mulchedState or 0)
				local _, numPixels = modifierLock:executeSetWithStats(1, fruitFilter, mulchFilter)
				if numPixels > 0 then
					for i = 1, 15 do
						if not fruitIndices[i].active then
							fruitIndices[i].index = index
							fruitIndices[i].terrainDataPlaneId = desc.terrainDataPlaneId
							fruitIndices[i].active = true
							break
						end
					end
				end
			end
		end
	end
	return 0
end

function FSDensityMapUtilExtension.postUpdateDestroyCommonArea(nitrogenMap, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local soilMap = nitrogenMap.soilMap
	if soilMap ~= nil and soilMap.bitVectorMap ~= nil then
		local modifier = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifier
		local nFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.nFilter
		local mulchFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.mulchFilter
		local modifierLock = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.modifierLock
		local lockFilter = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.lockFilter
		local fruitIndices = FSDensityMapUtilExtension.densityMapModifiersDestroyFruit.fruitIndices
		startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ = worldCoordsToLocalCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, FSDensityMapUtilExtension.mapSize, g_currentMission.terrainSize)
		modifier:setParallelogramDensityMapCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, DensityCoordType.POINT_POINT_POINT)
		for i = 1, 15 do
			if not fruitIndices[i].active then
				break
			end
			local desc = g_fruitTypeManager:getFruitTypeByIndex(fruitIndices[i].index)
			mulchFilter:resetDensityMapAndChannels(fruitIndices[i].terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels)
			mulchFilter:setValueCompareParams(DensityValueCompareType.NOTEQUAL, desc.mulchedState or 0)
			modifierLock:executeSet(2, mulchFilter)
		end
		nFilter:setValueCompareParams(DensityValueCompareType.EQUAL, FSDensityMapUtilExtension.maxValue - FSDensityMapUtilExtension.catchCropsStateChange)
		modifier:executeSet(FSDensityMapUtilExtension.maxValue, lockFilter, nFilter)
		nFilter:setValueCompareParams(DensityValueCompareType.BETWEEN, 0, FSDensityMapUtilExtension.maxValue - FSDensityMapUtilExtension.catchCropsStateChange)
		modifier:executeAdd(FSDensityMapUtilExtension.catchCropsStateChange, lockFilter, nFilter)
	end
	return 0
end
