-- shopConfigHandler.lua
-- Uses built-in design / design2 configurations and applies:
--  - discharge emptySpeed
--  - pallet stack grid offsets for PalletStacker

_G.ShopConfigHandler = _G.ShopConfigHandler or {}
local ShopConfigHandler = _G.ShopConfigHandler

function ShopConfigHandler.prerequisitesPresent(specializations)
    return true
end

function ShopConfigHandler.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", ShopConfigHandler)
end

function ShopConfigHandler:onLoad(savegame)
    if not self.isServer then
        return
    end

    ----------------------------------------------------------------------
    -- 1) READ RAW CONFIG INDICES FROM self.configurations
    ----------------------------------------------------------------------
    local configs = self.configurations or {}

    -- design  = unloading speed (3 options)
    -- index will be 1, 2 or 3 (or nil → default 1)
    -- design2 = stack pattern (3 options)
    local gridIndex   = configs.design2 or 1

    ----------------------------------------------------------------------
    -- 2) MAP GRID INDEX → OFFSET ARRAYS FOR PalletStacker
    ----------------------------------------------------------------------
    local xOffsets, yOffsets, zOffsets
    if gridIndex == 1 then
        -- Single row 2×1×1
        xOffsets = { -0.875, 0.875 }
        zOffsets = {  0.0}
        yOffsets = {  0.40}

    elseif gridIndex == 2 then
        -- 2×3×2 (small)
        xOffsets = { -0.875, 0.875 }
        zOffsets = {  0.0, -1.35, -2.70 }
        yOffsets = {  0.40, 1.80 }

    elseif gridIndex == 3 then
        -- 3×3×2 (default)
        xOffsets = { -1.75, 0.0, 1.75 }
        zOffsets = {  0.0, -1.35, -2.70 }
        yOffsets = {  0.40, 1.80 }

    elseif gridIndex == 4 then
        -- 3×4×3 (big)
        xOffsets = { -1.75, 0.0, 1.75 }
        zOffsets = {  0.0, -1.35, -2.70, -4.05 }
        yOffsets = {  0.40, 1.80, 3.20 }
    end

    

    self.ps_config = {
        x = xOffsets,
        y = yOffsets,
        z = zOffsets
    }

    --[[ print(string.format(
        "### ShopConfigHandler: gridIndex=%d -> %dx%dx%d slots",
        gridIndex, #xOffsets, #zOffsets, #yOffsets
    )) ]]
end

return ShopConfigHandler
